﻿using System;
using System.Diagnostics;
using System.Threading;
using System.Runtime.InteropServices;

namespace ProcessFreezer
{
    static class ProcessFreezer
    {
        [DllImport("kernel32.dll")]
        static extern IntPtr OpenThread(ThreadAccess dwDesiredAccess, bool bInheritHandle, uint dwThreadId);
        [DllImport("kernel32.dll")]
        static extern uint SuspendThread(IntPtr hThread);
        [DllImport("kernel32.dll")]
        static extern int ResumeThread(IntPtr hThread);


        [Flags]
        public enum ThreadAccess : int
        {
            TERMINATE = (0x0001),
            SUSPEND_RESUME = (0x0002),
            GET_CONTEXT = (0x0008),
            SET_CONTEXT = (0x0010),
            SET_INFORMATION = (0x0020),
            QUERY_INFORMATION = (0x0040),
            SET_THREAD_TOKEN = (0x0080),
            IMPERSONATE = (0x0100),
            DIRECT_IMPERSONATION = (0x0200)
        }


        public static void SuspendProcess(Process proc)
        {
            foreach (ProcessThread pT in proc.Threads)
            {
                IntPtr pOpenThread = OpenThread(ThreadAccess.SUSPEND_RESUME, false, (uint)pT.Id);
                if (pOpenThread == IntPtr.Zero)
                    break;
                SuspendThread(pOpenThread);
            }
        }

        public static void ResumeProcess(Process proc)
        {
            foreach (ProcessThread pT in proc.Threads)
            {
                IntPtr pOpenThread = OpenThread(ThreadAccess.SUSPEND_RESUME, false, (uint)pT.Id);
                if (pOpenThread == IntPtr.Zero)
                    break;
                ResumeThread(pOpenThread);
            }
        }

        public static bool ProcessIsSuspended(Process proc)
        {
            bool suspended = true;
            foreach (ProcessThread pT in proc.Threads)
                suspended &= (pT.ThreadState == System.Diagnostics.ThreadState.Wait && pT.WaitReason == ThreadWaitReason.Suspended);
            return suspended;
        }
    }
}
