﻿using System;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

namespace ProcessFreezer
{
    partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            RefreshProcessList();
        }

        void AddProcess(Process proc)
        {
            ListViewItem item = new ListViewItem();
            item.SubItems.Add(new ListViewItem.ListViewSubItem());
            item.SubItems.Add(new ListViewItem.ListViewSubItem());
            RefreshItem(item, proc);
            lvProcesses.Items.Add(item);
        }

        void RefreshProcessList()
        {
            lvProcesses.Items.Clear();
            Process[] procs = Process.GetProcesses();
            for (int i = 0; i < procs.Length; i++)
                AddProcess(procs[i]);
        }

        static void RefreshItem(ListViewItem item, Process proc)
        {
            item.Tag = proc;

            try
            {
                if (proc == null || proc.HasExited)
                {
                    item.Remove();
                    return;
                }
            }
            catch { }

            if (item.Text != proc.ProcessName)
            {
                item.Text = proc.ProcessName;
                item.SubItems[0].Text = item.Text;
            }

            Color fColor = Color.FromKnownColor(ProcessFreezer.ProcessIsSuspended(proc) ? KnownColor.InactiveCaptionText : KnownColor.ControlText);
            if (fColor != item.ForeColor)
                item.ForeColor = fColor;

            try
            {
                if (item.SubItems[1].Text != proc.MainModule.FileName)
                    item.SubItems[1].Text = proc.MainModule.FileName;
            }
            catch { }
        }

        Process[] GetCheckedProcesses()
        {
            Process[] procs = new Process[lvProcesses.CheckedItems.Count];
            for (int i = 0; i < procs.Length; i++)
                procs[i] = (Process)lvProcesses.CheckedItems[i].Tag;

            return procs;
        }

        private void btnKill_Click(object sender, EventArgs e)
        {
            Process[] procs = GetCheckedProcesses();
            for (int i = 0; i < procs.Length; i++)
            {
                try { procs[i].Kill(); }
                catch (Exception ex) { MessageBox.Show(ex.ToString(), "FEHLER"); }
            }
        }
        
        private void btnSuspend_Click(object sender, EventArgs e)
        {
            Process[] procs = GetCheckedProcesses();
               
            for (int i = 0; i < procs.Length; i++)
            {
                try { ProcessFreezer.SuspendProcess(procs[i]); ; }
                catch (Exception ex) { MessageBox.Show(ex.ToString(), "FEHLER"); }
            }
        }

        private void btnResume_Click(object sender, EventArgs e)
        {
            Process[] procs = GetCheckedProcesses();
            for (int i = 0; i < procs.Length; i++)
            {
                try { ProcessFreezer.ResumeProcess(procs[i]); ; }
                catch (Exception ex) { MessageBox.Show(ex.ToString(), "FEHLER"); }
            }
        }

        ListViewItem GetItemByProcess(Process proc)
        {
            for (int i = 0; i < lvProcesses.Items.Count; i++)
            {
                if (((Process)lvProcesses.Items[i].Tag).Id == proc.Id)
                    return lvProcesses.Items[i];
            }
            return null;
        }

        private void timerRefresh_Tick(object sender, EventArgs e)
        {
            Process[] procs = Process.GetProcesses();

            for (int i = 0; i < procs.Length; i++)
            {
                ListViewItem item = GetItemByProcess(procs[i]);
                if (item == null)
                    AddProcess(procs[i]);
                else
                    RefreshItem(item, procs[i]);
            }

            foreach (ListViewItem item in lvProcesses.Items)
            {
                bool exited = false;
                try { exited = (item.Tag == null || ((Process)item.Tag).HasExited); }
                catch { }

                if (exited)
                    item.Remove();
            }
        }

        private void lblWebsite_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start("http://fabi.me/");
        }

    }
}
