<?php

//
// Copyright (C) 2009 by Fabian Schlieper
// Traffic Limiter v1.0
// http://www.fabi.me/
// Ohne dieses Copyright darf dieser Code nicht verwendet werden!
//

// daily limit (in bytes)
define('MAX_DAILY_TRAFFIC', 1073741824 * 5); // 5 GiB

// monthly limit (in bytes)
define('MAX_MONTHLY_TRAFFIC', 1073741824 * 150); // 5 GiB

// maximum download speed (0 => unlimited) (in KB/s)
define('MAX_DOWNLOAD_SPEED', 0); // KiB/second

// the directory where the files are stored
define('FILES_ROOT_DIR', dirname(__FILE__) . '/files');

// the path of the file where traffic data is stored
define('TRAFFIC_STATS_FILE', dirname(__FILE__) . '/._traffic');

// the message text or url to redirect when traffic limit exceeded
define('TRAFFIC_EXCEEDED_MSG', 'Traffic limit exceeded!');


// ##################################################
// ##  CONFIGURATION ENDS HERE. NOTHING TO EDIT BELOW !!!
// ##################################################


set_time_limit(0);

if(empty($_GET['file']))
	exit;

$file_path = FILES_ROOT_DIR . '/' . str_replace('../', '' , $_GET['file']);
$file_size = filesize($file_path);

$traffic = get_traffic();

// check traffic limit
if( (($traffic['month'] + $file_size) > MAX_MONTHLY_TRAFFIC) || (($traffic['today'] + $file_size) > MAX_DAILY_TRAFFIC) )
{
	if(is_url(TRAFFIC_EXCEEDED_MSG)) {
		header('HTTP/1.x 307 Temporary Redirect');
		header('Location: ' . TRAFFIC_EXCEEDED_MSG);
	} else {
		header('HTTP/1.x 503 Service Unavailable');
	}
	die(TRAFFIC_EXCEEDED_MSG);	
}

add_traffic($file_size);
send_file($file_path, MAX_DOWNLOAD_SPEED);

function send_file($file_path, $max_dl_rate = 0)
{
	if(!@file_exists($file_path) || !is_file($file_path))
	{
		header('HTTP/1.x 404 Not Found');
		die('File ' . basename($file_path) . ' not found!');
	}
	
	$size = filesize($file_path);
	$time = filemtime($file_path);
	
	if(!($fh = @fopen($file_path, 'rb')))
		die('Could not open file!');
		
	$begin = 0;
	$end = $size;

	if(!empty($_SERVER['HTTP_RANGE']) && strpos($_SERVER['HTTP_RANGE'], 'bytes=') !== false)
	{
		$range = explode('-', trim(substr($_SERVER['HTTP_RANGE'], 6)));
		$begin = 0 + trim($range[0]);
		if(!empty($range[1]))
			$end = 0 + trim($range[1]);
	}
	
	if($begin > 0 || $end < $size)
		header('HTTP/1.0 206 Partial Content');
	else
		header('HTTP/1.0 200 OK');

	// modifiy some headers...
	header("Last-Modified: " . gmdate("D, d M Y H:i:s", $time) . " GMT"); 
	header("Pragma: public");
	header("Cache-Control: public");
	header('Accept-Ranges: bytes');
	
	// content headers
	header("Content-Description: File Transfer");
	header("Content-Type: application/octet-stream");
	header("Content-Disposition: attachment; filename=\"" . basename($file_path) . "\"");
	header("Content-Transfer-Encoding: binary");
	header("Content-Length: " . ($end-$begin));
	if(isset($_SERVER['HTTP_RANGE']))
		header("Content-Range: bytes " . $begin . "-" . ($end-1) . "/" . $size);
	
	header("Connection: close");
	
	@session_destroy();
	
	// send the file!
	
	$max_dl_rate = (float)$max_dl_rate;
	if($max_dl_rate <= 0)
		$max_dl_rate = 1024 * 1024;
	
	$buffer_size = (int)(1024 * min($max_dl_rate, 64));
	
	// convert kib/s => bytes/ms
	$max_dl_rate *= 1024;
	$max_dl_rate /= 1000;

	$cur = $begin;
	fseek($fh,$begin,0);
	while(!@feof($fh) && $cur < $end && @connection_status() == 0)
	{		
		$nbytes = min($buffer_size, $end-$cur);
		$ts = microtime(true);
		
		print @fread($fh, $nbytes);
		@ob_flush();
		@flush();
		
		$dt = (microtime(true) - $ts) * 1000; // dt = time delta in ms		
		$st = ($nbytes / $max_dl_rate) - $dt;
		if($st > 0)
			usleep($st * 1000);			
		
		$cur += $nbytes;
	}
	
	@fclose($fh);	
	return true;
}

function get_traffic()
{	
	$traffic = array('today' => 0, 'month' => 0);
		
	$cur_year = intval(date('Y'));
	$cur_month = intval(date('m'));
	$cur_day = intval(date('z'));

	$fh	= @fopen (TRAFFIC_STATS_FILE, 'r');
	
	$year = (fgets($fh));	
	if($cur_year == $year)
	{
		$month = (fgets($fh));
		$traffic['month'] = (fgets($fh));
		if($month != $cur_month)
			$traffic['month'] = 0;
			
		$day = (fgets($fh));
		$traffic['today'] = (fgets($fh));
		if($day != $cur_day)
			$traffic['today'] = 0;
	}
	@fclose ($fh);

	return $traffic;
}

function add_traffic($bytes)
{

	$traffic_stats = get_traffic();
	$traffic_stats['month'] += $bytes;
	$traffic_stats['today'] += $bytes;
	
	$cur_year = (date('Y'));
	$cur_month = (date('m'));
	$cur_day = (date('z'));
				
	$fh	= @fopen (TRAFFIC_STATS_FILE, 'w');
	fwrite($fh, $cur_year . "\n");
	
	fwrite($fh, $cur_month."\n");
	fwrite($fh, $traffic_stats['month']."\n");
	
	fwrite($fh, $cur_day."\n");
	fwrite($fh, $traffic_stats['today']);
	
	@fclose ($fh);
}

function is_url($str)
{
	$str = trim(strtolower($str));
	
	$pos = strpos($str, 'http://');
	if($pos !== false && $pos == 0)
		return true;
		
	$pos = strpos($str, 'https://');
	if($pos !== false && $pos == 0)
		return true;
		
	return false;
}

?>