﻿/*
    SocialControls - http://fabi.me/dev/socialcontrols/
    Copyright (C) 2011 Fabian Schlieper

    
    This library is released under the following license:
    
    Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported
    http://creativecommons.org/licenses/by-nc-sa/3.0/
    
    Author: Fabian Schlieper <fabian@fabi.me>
*/

using System;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SocialControls
{
    [ToolboxBitmapAttribute(typeof(FlattrButton), "Flattr16.bmp")]
    public partial class FlattrButton : UserControl
    {
        string thingUrl;
        bool compact;

        private void updateBtn()
        {
            if (!this.IsHandleCreated) return;

            this.Size = compact ? new System.Drawing.Size(109, 20) : new System.Drawing.Size(55, 62);
            
            webBrowser.Hide();

            if (!String.IsNullOrEmpty(thingUrl))
            {
                StringBuilder sb = new StringBuilder("http://api.flattr.com/button/view/?url=");
                sb.Append(Uri.EscapeDataString(thingUrl));
                if (compact)
                    sb.Append("&button=compact");
                webBrowser.Navigate(sb.ToString());
            }
        }

        /// <summary>
        /// The URL of the Thing to flattr
        /// </summary>
        [Description("Thing URL"),
         Category("Flattr"),
         DefaultValue(""),
         Browsable(true),
         Bindable(true)]
        public string ThingUrl
        {
            get { return thingUrl; }
            set
            {
                if (thingUrl == value) return;
                thingUrl = value;
                updateBtn();
            }
        }

        /// <summary>
        /// Use a compact button layout
        /// </summary>
        [Description("Compact Button"),
         Category("Flattr"),
         DefaultValue(false),
         Browsable(true),
         Bindable(true)]
        public bool Compact
        {
            get { return compact; }
            set
            {
                if (compact == value) return;
                compact = value;
                updateBtn();
            }
        }

        public FlattrButton()
        {
            InitializeComponent();
        }

        private void webBrowser_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            WebBrowser wb = (WebBrowser)sender;

            // check if the actual page was loaded, cancel on error
            if (wb.Document.Url.Port == -1) return;

            // apply background
            Color bg = this.BackColor;
            StringBuilder sb = new StringBuilder("background-color:rgb(");
            sb.Append(bg.R); sb.Append(',');
            sb.Append(bg.G); sb.Append(',');
            sb.Append(bg.B); sb.Append("); cursor:pointer;");
            wb.Document.Body.Style = sb.ToString();
            wb.Document.BackColor = bg;

            // set pointer cursor on all elements
            foreach (HtmlElement el in wb.Document.Body.All)
            {
                el.Style += "cursor:pointer;";
            }

           // this.BackColor = Color.Transparent;

            webBrowser.Show();
        }

        private void FlattrButton_Load(object sender, EventArgs e)
        {
            updateBtn();
        }

        static Image bgImage = null;

        protected override void OnPaintBackground(PaintEventArgs e)
        {
            base.OnPaintBackground(e);

            if (this.DesignMode)
            {
                if (bgImage == null)
                    bgImage = ToolboxBitmapAttribute.GetImageFromResource(typeof(FacebookLikeButton), "Flattr16.bmp", false);

                Point p = (Point)(this.Size - bgImage.Size);
                p.X /= 2; p.Y /= 2;
                e.Graphics.DrawImage(bgImage, p);
            }
        }
    }
}
